% Rehbock_Stuw_v3.m


g=9.81;
b=0.442;
hb=0.25;

ha=0.016;  % [ m ]
hW = 0.213;

bGoot = 0.4;


%Volgens "Rehbock stuw.pdf"
he=ha+0.0012;
ce=0.602+0.083*ha/hb;
q1=1000*ce*(2/3)*sqrt(2*g)*b*(he)^1.5 %[ liter/sec ]

%Volgens Bas:
he=ha+0.0012;
ce=0.602+0.083*he/hb;
q2=1000*ce*(2/3)*sqrt(2*g)*b*(he)^1.5 %[ liter/sec ]

% Volgens Sci-Tech Dictionary Rehbock weir formula
h=ha*3.2808;    % omgerekend naar ft
d0=hb*3.2808;
l=b*3.2808;
q3 = 1000*0.3048^3*(3.234+5.347/(320*h-3)+0.428*h/d0)*l*h^(3/2)  % teruggerekend naar dm^3/sec

v = q1 / (1000 * hW * bGoot)
%Antwoorden voor "ha=0.007" :
%q1 = 0.5857
%q2 = 0.5861
%q3 = 0.6396

%Antwoorden voor "ha=0.1956" :
%q1 = 75.9984
%q2 = 76.0438
%q3 = 75.8934

%Antwoorden voor "ha=0.020" :
%q1 = 2.4521
%q2 = 2.4537
%q3 = 2.4607

%Antwoorden voor "ha=0.10" :
%q1 = 26.6908
%q2 = 26.7076
%q3 = 26.6806