%% clean up

clear all
close all
clc

%% read files.
load calibrationsConstants.mat

automaticFileName = '20150706waderFieldWorkExperimentFinal.asc';
manualFileName = '20150706waderFieldWorkExperimentFinalManual.asc';

% the file of the measurement that logged every 5 seconds
fID=fopen(automaticFileName);
C=textscan(fID,'%s %f','Delimiter',',');
fclose(fID);

tAutomatic=zeros(length(C{1}),1);
for sample = 1:length(C{1});
    tAutomatic(sample)=datenum([automaticFileName(1:4) '-' automaticFileName(5:6) '-' automaticFileName(7:8) ' ' C{1}{sample}]);
end
RAutomatic=C{2};
TAutomatic = 1./(CalConst(1) + CalConst(2) * log(RAutomatic) + CalConst(3) * log(RAutomatic).^3) - 273.15;
 
% the file of the manual measurements, including the Fluke and the distance
% measurements.
% the file of the measurement that logged every 5 seconds
fID=fopen(manualFileName);
C=textscan(fID,'%s %f %f %f','Delimiter',',');
fclose(fID);

tManual=zeros(length(C{1}),1);
for sample = 1:length(C{1});
    tManual(sample)=datenum([manualFileName(1:4) '-' manualFileName(5:6) '-' manualFileName(7:8) ' ' C{1}{sample}]);
end
RManual=C{2};
TManual = 1./(CalConst(1) + CalConst(2) * log(RManual) + CalConst(3) * log(RManual).^3) - 273.15;
distanceManual = C{3};
Fluke = C{4};

%% make plots

distanceAutomatic = interp1(tManual,distanceManual,tAutomatic);

plot(distanceAutomatic,TAutomatic,'r',distanceManual,TManual,'xr',distanceManual,Fluke,'x-k')
xlabel('distance in meters','FontSize',16)
ylabel('Temperature in degrees C','FontSize',16)
legend({'wader temperature (every 5 seconds)','wader temperature (every meter)',...
    'Fluke reference temperature'},'Location','SouthWest','FontSize',12)
print(gcf,'figs/fieldWork.eps','-depsc');


