%% clean up

clear all
close all
clc

%% read files.
load calibrationsConstants.mat

expFileName = {'20151028waderFlumeEx1_LowFlow_NoFoot.asc','20151028waderFlumeEx2_LowFlow_Foot.asc',...
    '20151028waderFlumeEx3_MediumFlow_Foot.asc','20151028waderFlumeEx4_MediumFlow_NoFoot.asc',...
    '20151028waderFlumeEx5_HighFlow_NoFoot.asc','20151028waderFlumeEx6_HighFlow_Foot.asc'};
startTimesUp = {'2015-10-28 11:2:25';'2015-10-28 11:15:30';'2015-10-28 11:29:49';'2015-10-28 11:44:05'...
    ;'2015-10-28 11:58:20';'2015-10-28 12:11:50'};
endTimesUp = {'2015-10-28 11:6:41';'2015-10-28 11:20:30';'2015-10-28 11:35:52';'2015-10-28 11:49:16'...
    ;'2015-10-28 12:03:40';'2015-10-28 12:15:28'};
startTimesDown = {'2015-10-28 11:6:55';'2015-10-28 11:20:55';'2015-10-28 11:36:14';'2015-10-28 11:49:35';...
    '2015-10-28 12:04:07';'2015-10-28 12:15:34'};
endTimesDown = {'2015-10-28 11:12:2';'2015-10-28 11:29:13';'2015-10-28 11:40:16';'2015-10-28 11:54:27';...
    '2015-10-28 12:09:00';'2015-10-28 12:21:01'};
plotOrder = [1 2 4 3 5 6];
plotLength = 10 / (60*24);
YLim = [18 30];

%copied from excel file by Tim, based on his notes during the experiment

betaUp=zeros(length(expFileName),2);
betaDown=zeros(length(expFileName),2);
figure;

for fileNameCounter = 1:length(expFileName);
    fileName = expFileName{fileNameCounter};
    
    % the file of the measurement that logged every 5 seconds
    fID=fopen(fileName);
    C=textscan(fID,'%s %f','Delimiter',',');
    fclose(fID);
    
    tAutomatic=zeros(length(C{1}),1);
    for sample = 1:length(C{1});
        tAutomatic(sample)=datenum([fileName(1:4) '-' fileName(5:6) '-' fileName(7:8) ' ' C{1}{sample}]);
    end
    RAutomatic=C{2};
    TAutomatic = 1./(CalConst(1) + CalConst(2) * log(RAutomatic) + CalConst(3) * log(RAutomatic).^3) - 273.15;
    
    subplot(3,2,plotOrder(fileNameCounter));
    plot(tAutomatic,TAutomatic,'k')
    hold on
    set(gca,'XLim',[tAutomatic(1) tAutomatic(1) + plotLength]);
    set(gca,'YLim',YLim);
    set(gca,'XTickLabel',datestr(get(gca,'XTick'),'HH:MM:SS'));
    
    if 1
        startTimeUp = startTimesUp{fileNameCounter};
        endTimeUp = endTimesUp{fileNameCounter};
        startTimeDown = startTimesDown{fileNameCounter};
        endTimeDown = endTimesDown{fileNameCounter};
        tUpFilter=(tAutomatic > datenum(startTimeUp)) & (tAutomatic < datenum(endTimeUp));
        tUpPlot=tAutomatic(tUpFilter);
        tUp=tUpPlot-tUpPlot(1); %start at t = 0
        TUpPlot=TAutomatic(tUpFilter);
        TUp=TUpPlot-TUpPlot(1); %start with T = 0 for fitting
        
        [betaUp(fileNameCounter,:),TUpFit]=nlinfit(tUp,TUp,@expUp,[2/(60*24), 15]);
        tauUp(fileNameCounter) = betaUp(fileNameCounter,1)*60*24*60;
        TUpFitPlot = expUp(betaUp(fileNameCounter,:),tUp) + TUpPlot(1);
        
        tDownFilter=(tAutomatic > datenum(startTimeDown)) & (tAutomatic < datenum(endTimeDown));
        tDownPlot=tAutomatic(tDownFilter);
        tDown=tDownPlot-tDownPlot(1); %start at t = 0
        TDownPlot=TAutomatic(tDownFilter);
        TDown=TDownPlot-TDownPlot(1); %start with T = 0 for fitting
        
        [betaDown(fileNameCounter,:),TDownFit]=nlinfit(tDown,TDown,@expDown,[2/(60*24), 15]);
        tauDown(fileNameCounter) = betaDown(fileNameCounter,1)*60*24*60;
        TDownFitPlot = expDown(betaDown(fileNameCounter,:),tDown) + TDownPlot(1);
        
        plot(tUpPlot,TUpFitPlot,'r');
        plot(tDownPlot,TDownFitPlot,'r');
        
        text(tUpPlot(1)+1/(60*24),TUpFitPlot(1)+2,['\tau = ' num2str(tauUp(fileNameCounter),2) ' s'])
        text(tDownPlot(1)+1/(60*24),TDownFitPlot(1)-2,['\tau = ' num2str(tauDown(fileNameCounter),2) ' s'])
        %legend({'wader temperature (every 5 seconds)','fitted function'},'Location','NorthEast','FontSize',12);
        
    end %if 0
    
    
end %for filename = expFileName

%% make plots


if 1
    subplot(3,2,1);
    ylabel('flow: 0.02 m/s ','FontSize',16);
    subplot(3,2,3);
    ylabel({'Temperature in degrees C','flow: 0.17 m/s'},'FontSize',16)
    subplot(3,2,5);
    ylabel('flow: 0.38 m/s','FontSize',16);
    xlabel('time','FontSize',16)
    subplot(3,2,6);
    xlabel('time','FontSize',16)
    
    
    print(gcf,'figs/flumeExp1.eps','-depsc');
    
end %if 0