%% clean up.

clear all
close all
clc

%% make some figures to have a first look at the calibration data.

figure(1)
[TWader,TTidBit,tWader,tTidBit]=compareWaderTidBit('20150701waderCalibartionIceWaterFootBoot.asc',...
'waderCalibration4IceBath.csv','waderCalibration5IceBath.csv',30,1);

figure(2)
[TWader,TTidBit,tWader,tTidBit]=compareWaderTidBit('20150701waderCalibartionIceWaterEmptyBoot.asc',...
'waderCalibration4IceBath.csv','waderCalibration5IceBath.csv',30,1);


figure(3)
[TWader,TTidBit,tWader,tTidBit]=compareWaderTidBit('20150701waderCalibartionNormalWaterFootBoot.asc',...
'waderCalibration1WarmBath.csv','waderCalibration2WarmBath.csv',30,1);

figure(4)
[TWader,TTidBit,tWader,tTidBit]=compareWaderTidBit('20150701waderCalibartionNormalWaterNoBoot.asc',...
'waderCalibration1WarmBath.csv','waderCalibration2WarmBath.csv',30,1);

figure(5)
[TWader,TTidBit,tWader,tTidBit]=compareWaderTidBit('20150701waderCalibartionWarmWaterFootBoot.asc',...
'waderCalibration1WarmBath.csv','waderCalibration2WarmBath.csv',30,1);

figure(6)
[TWader,TTidBit,tWader,tTidBit]=compareWaderTidBit('20150701waderCalibartionWarmWaterNoBoot.asc',...
'waderCalibration1WarmBath.csv','waderCalibration2WarmBath.csv',30,1);

%% fit steinhart-hart curve to the end of the calibration measurements.

%those values are read from the above figures: they are the last points of
%all measurements. Every measuremnt, two tibits were located on the brick
%close to the the heel of the boot (where the thermistor is mounted. The
%third tidbit was on the bottom of the bucket.
Resistance = [1157 1005 511 474 264 236]; 
Temperature = [2.9 6.5 21.9 23.6 40.4 43.1];

%fit the Steinhart-Hart curve.
[CalConst, BINT, R, RINT]=steinharthart(Resistance, Temperature);
%save calibrationsConstants CalConst

%plot calibration curve and calibration measurements
r=200:1200;
That=1./(CalConst(1) + CalConst(2) * log(r) + CalConst(3) * log(r).^3) - 273.15;
figure(7)
plot(r,That,'r');
hold on
plot(Resistance, Temperature,'*k');
xlabel('Resistance in Ohms','FontSize',16);
ylabel('Temperature in degrees Celcius','FontSize',16);
title('calibration curve of temperature sensing waders','FontSize',16);
legend({'calibration curve','calibration measurements'},'FontSize',16);
%print(gcf,'figs/calibration.eps','-depsc');



