function [B, BINT, R, RINT]=steinharthart(resistence, temperature)


% the code below is copied and slightly adjusted from 
% http://www.eng.hmc.edu/NewE80/PresTempLec.html
% on july 7th, 2015.
% Rolf Hut.



% This is an example of a linear regression with three coefficients, B0,
% B1, and B2, for the Steinhart-Hart equation. These coefficients are labeled C1, C2, and
% C3, respectively in the equation in my notes.

% Measured Resistance values
R = resistence(:);

% Observed temperatures, corresponding to resistance matrix
T = temperature(:);

% Convert temperatures to Kelvin and create Y = 1/T
Y = 1./(T + 273.15);

X = [ones(size(R)) log(R) (log(R).^3)];  % the first column of this matrix must be 1's

% Perform linear reqression using least squares to solve for the
% coefficients B0, B1, and B2.
% B: a matrix of the coefficients, starting with B0
% BINT: a matrix of the confidence intervals (95% confidence) for each coefficient
% R: a matrix of the residuals
% RINT: a matrix of the confidence intervals (95% confidence) of the residuals, centered
% around each residual
[B, BINT, R, RINT] = regress(Y,X);