#!/bin/sh

script=${0##*/}

if [ $# -lt 1 ]; then
    echo "usage: $script host"
    exit 1
fi

dsm=$1

tmp1=$(mktemp /tmp/$script.XXXXXX)
tmp2=$(mktemp /tmp/$script.XXXXXX)
tmp3=$(mktemp /tmp/$script.XXXXXX)

trap "{ rm -f $tmp1 $tmp2 $tmp3; }" EXIT

rsync -v rsync://$dsm/data/$PROJECT/raw_data/ | awk '/-r--/{print $2,$5}' | sort > $tmp1 || exit 1

ls -lH $ISFF/projects/$PROJECT/ISFF/raw_data | awk '/-r--/{print $5,$9}' | sort > $tmp2

comm -1 -2 $tmp1 $tmp2 > $tmp3

if [ -s $tmp3 ]; then

    # cat $tmp3

    files=($(awk '{print $2}' $tmp3))

    # echo ${files[*]}

    # For this ssh to succeed without a password, this entry must be in ~/.ssh/config:
    #   Host 192.168.0.*
    #       User root
    #       IdentityFile ~/.ssh/id_dsa_dsm

    # ssh root@$dsm 'source .profile; cd $DATAMNT/projects/$PROJECT/raw_data; ls -l '${files[*]}
    ssh root@$dsm 'source .profile; cd $DATAMNT/projects/$PROJECT/raw_data; rm '${files[*]}

fi
