#!/bin/sh

PATH=/opt/nidas/bin:$PATH

# script that makes a tar ball of the project configuration to be
# installed on a DSM. It is copied to /tmp

if [ $# -lt 1 ]; then
    echo "$0 dsmname"
    exit 1
fi

dsm=$1

if [ $dsm == all ]; then
    for d in niwot niwot_dreamplug; do
        $0 $d || exit $?
    done
    exit 0
fi

xml=niwot.xml
fxml=$ISFF/projects/$PROJECT/ISFF/config/$xml

if ! fgrep -q "<dsm name=\"$dsm\"" $fxml; then
    echo "dsm name=$dsm not found in $fxml"
    exit 1
fi

ck_xml $fxml > /dev/null || exit 1

# tmpdir=/tmp/$PROJECT
tmpdir=`mktemp -d /tmp/scp_dsm_XXXXXX`
trap "{ rm -rf $tmpdir; }" EXIT

cd $ISFF/projects

rsync -aR --exclude=.svn --exclude="*~" $PROJECT/ISFF/config/$xml $PROJECT/ISFF/scripts/dsm $tmpdir
# rsync -aR --exclude=.svn --exclude="*~" $PROJECT/ISFF/cal_files/boom_normal $tmpdir
# rsync -aR --exclude=.svn --exclude="*~" $PROJECT/ISFF/cal_files/noQC $tmpdir

cd $tmpdir

# Use sed/cat to edit the XML to include just what we want - this should
# be done with XML tools, but...

# print <dsm> section for $dsm
# delete other <dsm> sections
# delete <server> section
# otherwise print

sed -i -e "
\;<dsm name=\"$dsm\";,\;</dsm;p
\;<dsm;,\;</dsm;d
\;<server;,\;</server;d
" $PROJECT/ISFF/config/$xml 

tf=/tmp/$dsm.tar.gz 
tar czvf $tf $PROJECT && echo "$tf ready"

exit 
