#!/bin/sh

# infinitely loop, at a period set by runperiod,

runperiod=86400 # seconds
runoffset=60    # seconds


# logdir=$ISFF/projects/$PROJECT/ISFF/logs
logdir=$ISFF/projects/$PROJECT/ISFF/logs

if which realpath > /dev/null && [ -L $logdir ]; then
    [ -d $(realpath $logdir) ] || mkdir -p $(realpath $logdir)
else
    [ -d $logdir ] || mkdir -p $logdir
fi

while true; do

    # seconds since 1970 0Z
    ut=`date +%s`
    iwait=$(( $runperiod + $runoffset - ( $ut % $runperiod ) ))
    # echo "`date`: iwait=$iwait"
    sleep $iwait

    while true; do
        niwot_rsync.sh > $logdir/niwot_rsync.log 2>&1 && break
        sleep 60
    done
    # echo "$0: `date`"

done

