#!/bin/sh

# rsync files from DSMs and run statsproc on them

logdir=$ISFF/projects/$PROJECT/ISFF/logs
[ -d $logdir ] || mkdir -p $logdir

export RSYNC_PARTIAL_DIR=.rsync-partial

export NETCDF_DIR=netcdf

cd /data/projects/NIWOT || exit 1

PATH=$PATH:/opt/nidas/bin

for dsm in isffa sonics; do

    case $dsm in
    isffa)
        host=isffa.colorado.edu
        file=niwot
        port=873
        ;;
    sonics)
        host=forestcam.colorado.edu
        file=sonics
        port=873
        ;;
    esac

    today=`date -u +%Y%m%d`
    # just in case this rsync runs right at the UTC day rollover
    tomor=$(date -u -d tomorrow +%Y%m%d)

    rsync -va --partial --no-g --omit-dir-times --no-perms --partial-dir=$RSYNC_PARTIAL_DIR \
        --contimeout=60 --timeout=60 --chmod=Dg+ws \
        --exclude="*${today}_*" \
        --exclude="*${tomor}_*" \
	rsync://$host:$port/data/$PROJECT/raw_data . || exit 1

	# --remove-source-files \

    cd raw_data

    # find files with a newer modification time than $logdir/.last.statsproc.$dsm 
    if [ -e $logdir/.last.statsproc.$dsm ]; then
        files=(`find . -regextype posix-extended -type f \
           -regex "./${file}_[0-9]{8}_[0-9]{6}.dat" \
           -newer $logdir/.last.statsproc.$dsm -print | sed s,^\./,, | sort`)
    else
        files=(`find . -regextype posix-extended -type f \
            -regex "./${file}_[0-9]{8}_[0-9]{6}.dat" -mtime -5 -print | sed s,^\./,, | sort`)
    fi

    # echo ${files[*]} 

    [ -d $ISFF/projects/$PROJECT/ISFF/$NETCDF_DIR ] || \
        mkdir -p $ISFF/projects/$PROJECT/ISFF/$NETCDF_DIR

    xml=`proj_configs -c $ISFF/projects/$PROJECT/ISFF/config/configs.xml | cut -d \  -f 2`

    echo "#files=${#files[*]}, files=${files[*]}"

    # commented out because of an error (see  /usr/local/aster/projects/NIWOT/ISFF/logs/niwot_rsync.log), 9/7/14, SpB.
    #
    if [ ${#files[*]} -gt 0 ]; then
    
        # set modification time on time-stamp file to
        # modification time of last file received
        fl=${files[$((${#files[*]}-1))]}
    
        statsproc -n 10 -x $xml -s 30 ${files[*]} || exit 1
        touch -m -r $fl $logdir/.last.statsproc.$dsm
    fi


    cd -
done
