#!/bin/sh

cd /data/data_new_data_system || exit 1

dsm=titan2

export RSYNC_PARTIAL_DIR=.rsync-partial

# set today value just before rsync
today=$(date -u +%Y%m%d)
# just in case this rsync runs right at the UTC day rollover
tomor=$(date -u -d tomorrow +%Y%m%d)

logdir=$ISFF/projects/$PROJECT/ISFF/logs
dir=$logdir/$today
[ -d $dir ] || mkdir -p $dir
logfile=$dir/rsync_$dsm.log

echo "starting: $(date)" >> $logfile

if rsync -va --partial --timeout=600 --contimeout=120 --chmod=Dg+ws --remove-sent-files --exclude="*${today}_*" --exclude="*${tomor}_*" rsync://$dsm/data/$PROJECT/raw_data/ . >> $logfile 2>&1; then
    echo "success: $(date)"$'\n' >> $logfile
    exit 0
else
    echo "failed: $(date)"$'\n' >> $logfile
    # if rsync failed, it didn't successfully remove sent files, so do it ourselves
    remove_sent_files.sh $dsm
    exit 1
fi

