"""The Model Architecture."""

import keras
from keras.models import Sequential
from keras import optimizers
from keras import layers
from keras.layers import Dense


def OzoNet(input_dim=30):
    '''
    Return the Compiled Ozonet Architecture.
        Input: None.
        Output: Compiled OzoNet Model (Ready for .fit()).
    '''
    OzoNet = Sequential()
    OzoNet.add(layer=layers.Conv2D(name='conv_layer_1', filters=128, padding='same',
                                   kernel_size=(2, 2), activation='relu', input_shape=(input_dim, input_dim, 1)))
    OzoNet.add(layer=layers.Conv2D(name='conv_layer_2', filters=64,
                                   padding='same', kernel_size=(3, 3), activation='relu'))
    OzoNet.add(layer=layers.Conv2D(name='conv_layer_3', filters=32,
                                   padding='same', kernel_size=(5, 5), activation='relu'))
    OzoNet.add(layer=layers.Conv2D(name='conv_layer_4', filters=1,
                                   padding='same', kernel_size=(2, 2), activation='linear'))
    rmsprop = optimizers.rmsprop(lr=0.001)
    OzoNet.compile(optimizer=rmsprop, loss='mean_squared_error',
                   metrics=['mean_squared_error'])
    return OzoNet
