"""We will train the model here."""

import pickle
import urllib.request
from pathlib import Path
import numpy as np
import keras
from keras.models import Sequential
from keras import optimizers
from keras import layers
from keras.layers import Dense

# local imports.
import ozonet
from ozonet.keras_proto import model
from ozonet.keras_proto import data
from ozonet.helpers import upload_model

# first we load the data.
data = data.OzoNetDataLoader(X_file_name='KNN_denoised_patches.npy',
                             y_file_name='raw_interpolated_patches.npy')

# then we load the architecture.
ozonet = model.OzoNet()

# then we train it on the loaded data.
history = ozonet.fit(x=data.X, y=data.y, epochs=33,
                     validation_split=0.2, batch_size=128)

# we save and upload the model.
ozonet.save(filepath='/tmp/keras_ozonet_model.h5')
upload_model(model_name='keras_ozonet_model.h5',
             bucket_folder='models')

# we save and upload the history of the training.
with open('/tmp/keras_history.pkl', 'wb') as history_file:
    pickle.dump(history.history, history_file)
upload_model(model_name='keras_history.pkl',
             bucket_folder='histories')
